% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_macro_predictors.R
\name{download_data_macro_predictors}
\alias{download_data_macro_predictors}
\title{Download and Process Macro Predictor Data}
\usage{
download_data_macro_predictors(
  type,
  start_date = NULL,
  end_date = NULL,
  sheet_id = "1bM7vCWd3WOt95Sf9qjLPZjoiafgF_8EG"
)
}
\arguments{
\item{type}{The type of dataset to download ("macro_predictors_monthly",
"macro_predictors_quarterly", "macro_predictors_annual").}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, the full dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, the full dataset is returned.}

\item{sheet_id}{The Google Sheets ID from which to download the dataset, with the
default "1bM7vCWd3WOt95Sf9qjLPZjoiafgF_8EG".}
}
\value{
A tibble with processed data, filtered by the specified date range
and including financial metrics.
}
\description{
Downloads and processes macroeconomic predictor data based on the specified
type (monthly, quarterly, or annual), date range, and source URL. The
function first checks if the specified type is supported, then downloads the
data from the provided URL (defaulting to a Google Sheets export link). It
processes the raw data into a structured format, calculating additional
financial metrics and filtering by the specified date range.
}
\examples{
\donttest{
 download_data_macro_predictors("macro_predictors_monthly")
}

}
