% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.tidyfit.models.R
\name{predict.tidyfit.models}
\alias{predict.tidyfit.models}
\title{Predict using a \code{tidyfit.models} frame}
\usage{
\method{predict}{tidyfit.models}(object, newdata, ..., .keep_grid_id = FALSE)
}
\arguments{
\item{object}{\code{model.frame} created using \code{\link{regress}}, \code{\link{classify}} or \code{\link{m}}}

\item{newdata}{New values at which predictions are to made}

\item{...}{currently not used}

\item{.keep_grid_id}{boolean. By default the grid ID column is dropped, if there is only one unique setting per model or group. \code{.keep_grid_id = TRUE} ensures that the column is never dropped.}
}
\value{
A 'tibble'.
}
\description{
The function generates predictions for all models in a \code{tidyfit.models} frame and outputs a tidy frame.
}
\details{
The function uses the 'model_object' column in a \code{tidyfit.model} frame to return predictions using the \code{newdata} argument for each model.

When the response variable is found in \code{newdata}, it is automatically included as a 'truth' column.
}
\examples{
data <- dplyr::group_by(tidyfit::Factor_Industry_Returns, Industry)
fit <- regress(data, Return ~ ., m("lm"), .mask = "Date")
predict(fit, data)

}
\seealso{
\code{\link{coef.tidyfit.models}}, \code{\link{residuals.tidyfit.models}} and \code{\link{fitted.tidyfit.models}}
}
\author{
Johann Pfitzinger
}
