% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_sed_samples.R
\name{hy_sed_samples}
\alias{hy_sed_samples}
\title{Extract instantaneous sediment sample information from the HYDAT database}
\format{
A tibble with 19 variables:
\describe{
\item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
\item{SED_DATA_TYPE}{Contains the type of sampling method used in collecting sediment for a station}
\item{Date}{Contains the time to the nearest minute of when the sample was taken}
\item{SAMPLE_REMARK_CODE}{Descriptive Sediment Sample Remark in English}
\item{TIME_SYMBOL}{An "E" symbol means the time is an estimate only}
\item{FLOW}{Contains the instantaneous discharge in cubic metres per second at the time the sample was taken}
\item{SYMBOL_EN}{Indicates a condition where the daily mean has a larger than expected error}
\item{SAMPLER_TYPE}{Contains the type of measurement device used to take the sample}
\item{SAMPLING_VERTICAL_LOCATION}{The location on the cross-section of the river
at which the single sediment samples are collected. If one of the standard
locations is not used the distance in meters will be shown}
\item{SAMPLING_VERTICAL_EN}{Indicates sample location relative to the
regular measurement cross-section or the regular sampling site}
\item{TEMPERATURE}{Contains the instantaneous water temperature
in Celsius at the time the sample was taken}
\item{CONCENTRATION_EN}{Contains the instantaneous concentration sampled in milligrams per litre}
\item{SV_DEPTH2}{Depth 2 for split vertical depth integrating (m)}
}
}
\source{
HYDAT
}
\usage{
hy_sed_samples(
  station_number = NULL,
  hydat_path = NULL,
  prov_terr_state_loc = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}. Will also accept \code{CA} to return only Canadian stations.}

\item{start_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}

\item{end_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}
}
\value{
A tibble of instantaneous sediment samples data
}
\description{
Provides wrapper to turn the hy_sed_samples table in HYDAT into a tidy data frame of instantaneous sediment sample information.
\code{station_number} and \code{prov_terr_state_loc} can both be supplied. If both are omitted all values from the \code{hy_stations}
table are returned. That is a large vector for \code{hy_sed_samples}.
}
\examples{
\dontrun{
hy_sed_samples(station_number = "01CA004")
}

}
\seealso{
Other HYDAT functions: 
\code{\link{hy_agency_list}()},
\code{\link{hy_annual_instant_peaks}()},
\code{\link{hy_annual_stats}()},
\code{\link{hy_daily_flows}()},
\code{\link{hy_daily_levels}()},
\code{\link{hy_daily}()},
\code{\link{hy_data_symbols}},
\code{\link{hy_data_types}},
\code{\link{hy_datum_list}()},
\code{\link{hy_monthly_flows}()},
\code{\link{hy_monthly_levels}()},
\code{\link{hy_reg_office_list}()},
\code{\link{hy_sed_daily_loads}()},
\code{\link{hy_sed_daily_suscon}()},
\code{\link{hy_sed_monthly_loads}()},
\code{\link{hy_sed_monthly_suscon}()},
\code{\link{hy_sed_samples_psd}()},
\code{\link{hy_stations}()},
\code{\link{hy_stn_data_coll}()},
\code{\link{hy_stn_data_range}()},
\code{\link{hy_stn_op_schedule}()},
\code{\link{hy_stn_regulation}()},
\code{\link{hy_version}()}
}
\concept{HYDAT functions}
