% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imported-fun.R
\name{find_difference}
\alias{find_difference}
\title{Return the regions in which the smooth is significantly different from zero.}
\usage{
find_difference(mean, se, xVals = NULL, f = 1, as.vector = FALSE)
}
\arguments{
\item{mean}{A vector with smooth predictions.}

\item{se}{A vector with the standard error on the smooth predictions.}

\item{xVals}{Optional vector with x values for the smooth.
When \code{xVals} is provided, the regions are returned in terms of x-
values, otherwise as indices.}

\item{f}{A number to multiply the \code{se} with, to convert the \code{se}
into confidence intervals. Use 1.96 for 95\% CI and 2.58 for 99\%CI.}

\item{as.vector}{Logical: whether or not to return the data points as
vector, or not. Default is FALSE, and a list with start and end points will
be returned.}
}
\value{
The function returns a list with start points of each region
(\code{start}) and end points of each region (\code{end}). The logical
\code{xVals} indicates whether the returned values are on the x-scale
(TRUE) or indices (FALSE).
}
\description{
Return the regions in which the smooth is significantly different from zero.
}
\author{
Jacolien van Rij
}
\keyword{internal}
