% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-general.R
\name{add_sem_errorbar}
\alias{add_sem_errorbar}
\alias{add_range_errorbar}
\alias{add_sd_errorbar}
\alias{add_ci95_errorbar}
\title{Add error bar}
\usage{
add_sem_errorbar(
  plot,
  dodge_width = NULL,
  width = 0.4,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_range_errorbar(
  plot,
  dodge_width = NULL,
  width = 0.4,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_sd_errorbar(
  plot,
  dodge_width = NULL,
  width = 0.4,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_ci95_errorbar(
  plot,
  dodge_width = NULL,
  width = 0.4,
  linewidth = 0.25,
  preserve = "total",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
\itemize{
\item \code{add_sem_errorbar()} adds the standard error of mean.
\item \code{add_range_errorbar()} adds the range from smallest to largest value.
\item \code{add_sd_errorbar()} adds the standard deviation.
\item \code{add_ci95_errorbar()} adds the 95\% confidence interval.
}
}
\examples{
# Standard error of the mean
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_sem_errorbar()

# Range from minimum to maximum value
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_range_errorbar()

# Standard deviation
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_sd_errorbar()

# 95\% confidence interval
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_ci95_errorbar()

# Changing arguments: error bar width
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_sem_errorbar(width = 0.8)

# Changing arguments: error bar line width
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_sem_errorbar(linewidth = 1)

}
