% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_text_vector_list_to_string.R
\name{vector_list_to_string}
\alias{vector_list_to_string}
\title{Convert a named or unnamed list/vector to a string representation}
\usage{
vector_list_to_string(obj, how = c("inline", "expanded"))
}
\arguments{
\item{obj}{A list or vector (named or unnamed) to be converted to a string.}

\item{how}{In what way the object should be converted to a string;
either "inline" or "expanded". "inline" presents all key-value pairs
or values as a single line. "expanded" presents each key-value pair or value
on a separate line.}
}
\value{
A single string representing the list/vector.
}
\description{
Converts a named or unnamed list/vector to a string format, intended for
sending it to an LLM (or for display or logging).
}
\examples{
named_vector <- c(x = 10, y = 20, z = 30)

vector_list_to_string(named_vector, how = "inline")

vector_list_to_string(named_vector, how = "expanded")
}
\seealso{
Other text_helpers: 
\code{\link{df_to_string}()},
\code{\link{skim_with_labels_and_levels}()}
}
\concept{text_helpers}
