% Generated by roxygen2 (4.0.1): do not edit by hand
\name{separate}
\alias{separate}
\title{Separate one column into multiple columns.}
\usage{
separate(data, col, into, sep = "[^[:alnum:]]+", remove = TRUE,
  convert = FALSE, ...)
}
\arguments{
\item{col}{Bare column name.}

\item{data}{A data frame.}

\item{into}{Names of new variables to create as character vector.}

\item{sep}{Separator between columns.

  If character, is interpreted as a regular expression. The default
  value is a regular expression that matches any sequence of
  non-alphanumeric values.

  If numeric, interpreted as positions to split at. Positive values start
  at 1 at the far-left of the string; negative value start at -1 at the
  far-right of the string. The length of \code{sep} should be one less than
  \code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link{type.convert}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.}

\item{...}{Other arguments passed on to \code{\link{strsplit}} to control
how the regular expression is processed.}
}
\description{
Given either regular expression or a vector of character positions,
\code{separate()} turns a single character column into multiple columns.
}
\examples{
library(dplyr)
df <- data.frame(x = c("a.b", "a.d", "b.c"))
df \%>\% separate(x, c("A", "B"))
}

