% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather.R
\name{gather}
\alias{gather}
\title{Gather columns into key-value pairs.}
\usage{
gather(data, key = "key", value = "value", ..., na.rm = FALSE,
  convert = FALSE, factor_key = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{key, value}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:ensym]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{A selection of columns. If empty, all variables are
selected. You can supply bare variable names, select all
variables between x and z with \code{x:z}, exclude y with \code{-y}. For
more options, see the \code{\link[dplyr:select]{dplyr::select()}} documentation. See also
the section on selection rules below.}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column is \code{NA}.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link[=type.convert]{type.convert()}} on the key column. This is useful if the column
types are actually numeric, integer, or logical.}

\item{factor_key}{If \code{FALSE}, the default, the key values will be
stored as a character vector. If \code{TRUE}, will be stored as a factor,
which preserves the original ordering of the columns.}
}
\description{
Gather takes multiple columns and collapses into key-value pairs,
duplicating all other columns as needed. You use \code{gather()} when
you notice that you have columns that are not variables.
}
\section{Rules for selection}{


Arguments for selecting columns are passed to
\code{\link[tidyselect:vars_select]{tidyselect::vars_select()}} and are treated specially. Unlike other
verbs, selecting functions make a strict distinction between data
expressions and context expressions.
\itemize{
\item A data expression is either a bare name like \code{x} or an expression
like \code{x:y} or \code{c(x, y)}. In a data expression, you can only refer
to columns from the data frame.
\item Everything else is a context expression in which you can only
refer to objects that you have defined with \code{<-}.
}

For instance, \code{col1:col3} is a data expression that refers to data
columns, while \code{seq(start, end)} is a context expression that
refers to objects from the contexts.

If you really need to refer to contextual objects from a data
expression, you can unquote them with the tidy eval operator
\code{!!}. This operator evaluates its argument in the context and
inlines the result in the surrounding function call. For instance,
\code{c(x, !! x)} selects the \code{x} column within the data frame and the
column referred to by the object \code{x} defined in the context (which
can contain either a column name as string or a column position).
}

\examples{
library(dplyr)
# From http://stackoverflow.com/questions/1181060
stocks <- tibble(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

gather(stocks, "stock", "price", -time)
stocks \%>\% gather("stock", "price", -time)

# get first observation for each Species in iris data -- base R
mini_iris <- iris[c(1, 51, 101), ]
# gather Sepal.Length, Sepal.Width, Petal.Length, Petal.Width
gather(mini_iris, key = "flower_att", value = "measurement",
       Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
# same result but less verbose
gather(mini_iris, key = "flower_att", value = "measurement", -Species)

# repeat iris example using dplyr and the pipe operator
library(dplyr)
mini_iris <-
  iris \%>\%
  group_by(Species) \%>\%
  slice(1)
mini_iris \%>\% gather(key = "flower_att", value = "measurement", -Species)
}
