% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxent.R
\name{maxent}
\alias{maxent}
\title{MaxEnt model}
\usage{
maxent(
  mode = "classification",
  engine = "maxnet",
  feature_classes = NULL,
  regularization_multiplier = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Currently only "maxnet" is available.}

\item{feature_classes}{character, continuous feature classes desired, either
"default" or any subset of "lqpht" (for example, "lh")}

\item{regularization_multiplier}{numeric, a constant to adjust regularization}
}
\value{
a \code{\link[parsnip:model_spec]{parsnip::model_spec}} for a \code{maxent} model
}
\description{
\code{maxent} defines the MaxEnt model as used in Species
Distribution Models.
A good guide to how options of a MaxEnt model work can be found in
https://onlinelibrary.wiley.com/doi/full/10.1111/j.1600-0587.2013.07872.x
}
\examples{
\donttest{
# format the data
data("bradypus", package = "maxnet")
bradypus_tb <- tibble::as_tibble(bradypus) \%>\%
  dplyr::mutate(presence = relevel(
    factor(
      dplyr::case_match(presence, 1 ~ "presence", 0 ~ "absence")
    ),
    ref = "presence"
  )) \%>\%
  select(-ecoreg)

# fit the model, and make some predictions
maxent_spec <- maxent(feature_classes = "lq")
maxent_fitted <- maxent_spec \%>\%
  fit(presence ~ ., data = bradypus_tb)
pred_prob <- predict(maxent_fitted, new_data = bradypus[, -1], type = "prob")
pred_class <- predict(maxent_fitted, new_data = bradypus[, -1], type = "class")

# Now with tuning
maxent_spec <- maxent(
  regularization_multiplier = tune(),
  feature_classes = tune()
)
set.seed(452)
cv <- vfold_cv(bradypus_tb, v = 2)
maxent_tune_res <- maxent_spec \%>\%
  tune_grid(presence ~ ., cv, grid = 3)
show_best(maxent_tune_res, metric = "roc_auc")
}
}
