% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_background.R
\name{sample_background}
\alias{sample_background}
\title{Sample background points for SDM analysis}
\usage{
sample_background(
  data,
  raster,
  n,
  coords = NULL,
  method = "random",
  class_label = "background",
  return_pres = TRUE
)
}
\arguments{
\item{data}{An \code{\link[sf:sf]{sf::sf}} data frame, or a data frame with coordinate variables.
These can be defined in \code{coords}, unless they have standard names
(see details below).}

\item{raster}{the \link[terra:SpatRaster-class]{terra::SpatRaster} from which cells will be sampled (the first layer
will be used to determine which cells are NAs, and thus can not be sampled). If
sampling is "biased", then the sampling probability will be proportional to the values on
the first layer (i.e. band) of the raster.}

\item{n}{number of background points to sample.}

\item{coords}{a vector of length two giving the names of the "x" and "y"
coordinates, as found in \code{data}. If left to NULL, the function will
try to guess the columns based on standard names \code{c("x", "y")}, \code{c("X","Y")},
\code{c("longitude", "latitude")}, or \code{c("lon", "lat")}.}

\item{method}{sampling method. One of 'random', 'dist_max', and 'targeted'.
For dist_max, the maximum distance is set as an additional element of a vector,
e.g c('dist_max',70000).}

\item{class_label}{the label given to the sampled points. Defaults to \code{background}}

\item{return_pres}{return presences together with background
in a single tibble.}
}
\value{
An object of class \link[tibble:tibble]{tibble::tibble}. If presences are returned, the
presence level is set as the reference (to match the expectations in the
\code{yardstick} package that considers the first level to be the event).
}
\description{
This function samples background points from a raster given a set of presences.
The locations returned as the center points of the sampled cells, which can
overlap with the presences (in contrast to pseudo-absences, see
\link{sample_pseudoabs}). The following methods are implemented:
\itemize{
\item 'random': background randomly sampled from the region covered by the
raster (i.e. not NAs).
\item 'dist_max': background randomly sampled from the unioned buffers
of 'dist_max' from presences (distances in 'm' for lonlat rasters, and in map
units for projected rasters). Using the union of buffers means that areas that
are in multiple buffers are not oversampled. This is also referred to as "thickening".
\item 'bias': background points are sampled according to a surface representing
the biased sampling effort.
}
}
\details{
Note that the units of distance depend on the projection of the raster.
}
