% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complement.R
\name{complement}
\alias{complement}
\alias{complement.sq_dna_bsc}
\alias{complement.sq_dna_ext}
\alias{complement.sq_rna_bsc}
\alias{complement.sq_rna_ext}
\title{Create complement sequence from dnasq or rnasq object}
\usage{
complement(x, ...)

\method{complement}{sq_dna_bsc}(x, ..., NA_letter = getOption("tidysq_NA_letter"))

\method{complement}{sq_dna_ext}(x, ..., NA_letter = getOption("tidysq_NA_letter"))

\method{complement}{sq_rna_bsc}(x, ..., NA_letter = getOption("tidysq_NA_letter"))

\method{complement}{sq_rna_ext}(x, ..., NA_letter = getOption("tidysq_NA_letter"))
}
\arguments{
\item{x}{[\code{sq_dna_bsc} || \code{sq_rna_bsc} || \code{sq_dna_ext} ||
\code{sq_rna_ext}]\cr
 An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
\code{\link[=sq-class]{sq}} object of the same type as input but
built of nucleotides complementary to those in the entered sequences.
}
\description{
Creates the complementary sequence from a given RNA or DNA 
sequence. The function keeps the type of sequence intact.
}
\details{
This function matches elements of sequence to their complementary letters.
For unambiguous letters, "\code{C}" is matched with "\code{G}" and "\code{A}"
is matched with either "\code{T}" (thymine) or "\code{U}" (uracil), depending
on whether input is of \strong{dna} or \strong{rna} type.

Ambiguous letters are matched as well, for example "\code{N}" (any
nucleotide) is matched with itself, while "\code{B}" (not alanine) is matched
with "\code{V}" (not thymine/uracil).
}
\examples{
# Creating DNA and RNA sequences to work on:
sq_dna <- sq(c("ACTGCTG", "CTTAGA", "CCCT", "CTGAATGT"),
             alphabet = "dna_bsc")
sq_rna <- sq(c("BRAUDUG", "URKKBKUCA", "ANKRUGBNNG", "YYAUNAAAG"),
             alphabet = "rna_ext")

# Here complement() function is used to make PCR (Polymerase Chain Reaction)
# primers. Every sequence is rewritten to its complementary equivalent as
# in the following example: AAATTTGGG -> TTTAAACCC.

complement(sq_dna)
complement(sq_rna)

# Each sequence have now a complementary equivalent, which can be helpful
# during constructing PCR primers.

}
\seealso{
\code{\link[=sq-class]{sq}}

Functions interpreting sq in biological context:
\code{\link{\%has\%}()},
\code{\link{find_motifs}()},
\code{\link{translate}()}
}
\concept{bio_functions}
