% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-methods.R
\name{as.sq}
\alias{as.sq}
\alias{as.sq.default}
\alias{as.sq.character}
\title{Convert an object to sq}
\usage{
as.sq(x, ...)

\method{as.sq}{default}(x, ...)

\method{as.sq}{character}(x, ...)
}
\arguments{
\item{x}{[\code{any}]
An object of a class that supports conversion to \code{sq} class.}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
An \code{sq} object.
}
\description{
Takes an object of arbitrary type and returns an
\code{\link[=sq-class]{sq}} object as an output.
}
\details{
There are two possible cases: if \code{x} is a character vector, then this
method calls \code{\link{sq}} function, else it passes \code{x} to
\code{\link{import_sq}} and hopes it works.
}
\examples{
# Constructing an example sequence in the usual way:
sq_1 <- sq("CTGA")

# Using a method for character vector:
sq_2 <- as.sq("CTGA")

# Checking that both objects are identical:
identical(sq_1, sq_2)

}
\seealso{
Functions from output module:
\code{\link{as.character.sq}()},
\code{\link{as.matrix.sq}()},
\code{\link{export_sq}()},
\code{\link{write_fasta}()}
}
\concept{output_functions}
