% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_split.R
\name{group_split}
\alias{group_split}
\title{Split data frame by groups}
\usage{
group_split(.df, ..., .keep = TRUE, .named = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group and split by. \code{tidyselect} compatible.}

\item{.keep}{Should the grouping columns be kept}

\item{.named}{\emph{experimental}: Should the list be named with labels that identify the group}
}
\description{
Split data frame by groups. Returns a list.
}
\examples{
df <- tidytable(
  a = 1:3,
  b = 1:3,
  c = c("a", "a", "b"),
  d = c("a", "a", "b")
)

df \%>\%
  group_split(c, d)

df \%>\%
  group_split(c, d, .keep = FALSE)

df \%>\%
  group_split(c, d, .named = TRUE)
}
