% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R, R/map2.R
\name{map.}
\alias{map.}
\alias{dt_map}
\alias{map_lgl.}
\alias{dt_map_lgl}
\alias{map_int.}
\alias{dt_map_int}
\alias{map_dbl.}
\alias{dt_map_dbl}
\alias{map_chr.}
\alias{dt_map_chr}
\alias{map_dfc.}
\alias{dt_map_dfc}
\alias{map_dfr.}
\alias{dt_map_dfr}
\alias{map_df.}
\alias{dt_map_df}
\alias{walk.}
\alias{map2.}
\alias{dt_map2}
\alias{map2_lgl.}
\alias{dt_map2_lgl}
\alias{map2_int.}
\alias{dt_map2_int}
\alias{map2_dbl.}
\alias{dt_map2_dbl}
\alias{map2_chr.}
\alias{dt_map2_chr}
\alias{map2_dfc.}
\alias{dt_map2_dfc}
\alias{map2_dfr.}
\alias{dt_map2_dfr}
\alias{map2_df.}
\alias{dt_map2_df}
\title{Apply a function to each element of a vector}
\usage{
map.(.x, .f, ...)

dt_map(.x, .f, ...)

map_lgl.(.x, .f, ...)

dt_map_lgl(.x, .f, ...)

map_int.(.x, .f, ...)

dt_map_int(.x, .f, ...)

map_dbl.(.x, .f, ...)

dt_map_dbl(.x, .f, ...)

map_chr.(.x, .f, ...)

dt_map_chr(.x, .f, ...)

map_dfc.(.x, .f, ...)

dt_map_dfc(.x, .f, ...)

map_dfr.(.x, .f, ..., .id = NULL)

dt_map_dfr(.x, .f, ..., .id = NULL)

map_df.(.x, .f, ..., .id = NULL)

dt_map_df(.x, .f, ..., .id = NULL)

walk.(.x, .f, ...)

map2.(.x, .y, .f, ...)

dt_map2(.x, .y, .f, ...)

map2_lgl.(.x, .y, .f, ...)

dt_map2_lgl(.x, .y, .f, ...)

map2_int.(.x, .y, .f, ...)

dt_map2_int(.x, .y, .f, ...)

map2_dbl.(.x, .y, .f, ...)

dt_map2_dbl(.x, .y, .f, ...)

map2_chr.(.x, .y, .f, ...)

dt_map2_chr(.x, .y, .f, ...)

map2_dfc.(.x, .y, .f, ...)

dt_map2_dfc(.x, .y, .f, ...)

map2_dfr.(.x, .y, .f, ..., .id = NULL)

dt_map2_dfr(.x, .y, .f, ...)

map2_df.(.x, .y, .f, ..., .id = NULL)

dt_map2_df(.x, .y, .f, ..., .id = NULL)
}
\arguments{
\item{.x}{A list or vector}

\item{.f}{A function}

\item{...}{Other arguments to pass to a function}

\item{.id}{Whether \code{map_dfr.()} should add an id column to the finished dataset}

\item{.y}{A list or vector}
}
\description{
The map functions transform their input by applying a function to each element and returning
a list/vector/data.table.
\itemize{
\item \code{map.()} returns a list
\item \verb{_lgl.()}, \verb{_int.()}, \verb{_dbl.()},\verb{_chr.()}, \verb{_df.()} variants return their specified type
\item \verb{_dfr.()} & \verb{_dfc.()} Return all data frame results combined utilizing row or column binding
}
}
\examples{
map.(c(1,2,3), ~ .x + 1)

map_dbl.(c(1,2,3), ~ .x + 1)

map_chr.(c(1,2,3), as.character)
}
