% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_longer.R
\name{pivot_longer.}
\alias{pivot_longer.}
\title{Pivot data from wide to long}
\usage{
pivot_longer.(
  .df,
  cols = everything(),
  names_to = "name",
  values_to = "value",
  values_drop_na = FALSE,
  ...
)
}
\arguments{
\item{.df}{The data table to pivot longer}

\item{cols}{Vector of bare column names. Can add/drop columns. \code{tidyselect} compatible.}

\item{names_to}{Name of the new "names" column. Must be a string.}

\item{values_to}{Name of the new "values" column. Must be a string.}

\item{values_drop_na}{If TRUE, rows will be dropped that contain NAs.}

\item{...}{Additional arguments to pass to \code{melt.data.table()}}
}
\description{
\code{pivot_wider.()} "widens" data, increasing the number of columns and
decreasing the number of rows. The inverse transformation is
\code{pivot_longer.()}. Syntax based on the \code{tidyr} equivalents.
}
\examples{
test_df <- data.table(
  x = c(1,2,3),
  y = c(4,5,6),
  z = c("a", "b", "c"))

test_df \%>\%
  pivot_longer.(c(x, y))

test_df \%>\%
  pivot_longer.(cols = -z, names_to = "stuff", values_to = "things")
}
