% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{print.tidygtfs}
\alias{print.tidygtfs}
\title{Print a GTFS object}
\usage{
\method{print}{tidygtfs}(x, ...)
}
\arguments{
\item{x}{a tidygtfs object as read by \code{\link[=read_gtfs]{read_gtfs()}}}

\item{...}{Optional arguments ultimately passed to \code{format}.}
}
\value{
The GTFS object that was printed, invisibly
}
\description{
Prints a GTFS object suppressing the \code{class} attribute and hiding the
validation_result attribute, created with \code{\link[=validate_gtfs]{validate_gtfs()}}.
}
\examples{
 \dontrun{
path = system.file("extdata", 
           "nyc_subway.zip", 
           package = "tidytransit")

g = read_gtfs(path)
print(g)
}
}
