% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pac_toc.R
\name{pac_toc}
\alias{pac_toc}
\title{Calculate DOC Concentration in PAC system}
\source{
See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}

CHO(2007)
}
\usage{
pac_toc(water, dose, time, type = "bituminous")
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}}

\item{dose}{Applied PAC dose (mg/L). Model results are valid for doses concentrations between 5 and 30 mg/L.}

\item{time}{Contact time (minutes). Model results are valid for reaction times between 10 and 1440 minutes}

\item{type}{Type of PAC applied, either "bituminous", "lignite", "wood".}
}
\value{
A water class object with post-PAC predicted DOC and UV254.
}
\description{
Calculates DOC concentration multiple linear regression model found in 2-METHYLISOBORNEOL AND NATURAL ORGANIC MATTER
ADSORPTION BY POWDERED ACTIVATED CARBON by HYUKJIN CHO (2007)
Required arguments include an object of class "water"
created by \code{\link{define_water}} initial DOC concentration, amount of PAC added to system, contact time with PAC, type of PAC

water must contain DOC or TOC value.
}
\details{
The function will calculate DOC concentration by PAC adsorption in drinking water treatment.
UV254 concentrations are predicted based on a linear relationship with DOC.
}
\examples{
water <- define_water(toc = 2.5, uv254 = .05, doc = 1.5) \%>\%
  pac_toc(dose = 15, time = 50, type = "wood")

}
