% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{insertFigureData}
\alias{insertFigureData}
\title{Insert figure data directly to the database}
\usage{
insertFigureData(db, experimentName, regulatorName, filenames, name = "",
  description = "", priority = 0)
}
\arguments{
\item{db}{Database object created by \code{\link{initializeDb}}}

\item{experimentName}{Experiment name}

\item{regulatorName}{Regulator name (more detailed experiment identifier)}

\item{filenames}{A list of file names of PNG figures.  names of the list
must correspond to the names of the entities the figures are for.}

\item{name}{Optional figure name}

\item{description}{Optional figure description}

\item{priority}{Integer priority used for sorting figures (default: 0)}
}
\value{
An updated database object db
}
\description{
Insert figure data directly to the database
}
\examples{
  db <- initializeDb("", "My Dataset")
  logl <- c(-4.0, -2.0, 0.0)
  names(logl) <- c("A", "B", "C")
  baselogl <- c(1.0, -1.0, 4.0)
  names(baselogl) <- names(logl)
  db <- insertResults(db, "testexperiment", "testregulator", "",
                      logl, baselineloglikelihoods=baselogl)
  # Generate a dummy plot (reused for all data elements for simplicity)
  examplefile <- tempfile("plot", fileext=".png")
  png(examplefile)
  plot(c(0, 1), c(0, 1))
  dev.off()
  figures <- list(A=examplefile, B=examplefile, C=examplefile)
  db <- insertFigureData(db, "testexperiment", "testregulator",
                         figures)
  closeDb(db)
}

