% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.R
\name{linear_water}
\alias{linear_water}
\title{Download an linear water shapefile into R}
\usage{
linear_water(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like to
download the water features for. Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the water
features for.  Can also be a county name.}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
From the US Census Bureau: "The linear hydrography shapefile contains all linear
features with "H" (Hydrography) type MTFCCs in the
MAF/TIGER database by county. The shapefiles are provided at a county geographic extent and in linear
elemental feature geometry. The linear hydrography shapefile includes streams/rivers, braided streams,
canals, ditches, artificial paths, and aqueducts. A linear hydrography feature may include edges with both
perennial and intermittent persistence."
}
\examples{
\dontrun{
library(tigris)
library(sp)

dallas_water <- linear_water("TX", "Dallas")

plot(dallas_water)

}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other water functions: \code{\link{area_water}},
  \code{\link{coastline}}
}
