% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/national.R
\name{regions}
\alias{regions}
\title{Download a US regions cartographic boundary shapefile into R}
\usage{
regions(resolution = "500k", year = NULL, ...)
}
\arguments{
\item{resolution}{The resolution of the cartographic boundary file.
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2017).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sp"} (the default) or \code{"sf"} to
request sp or sf class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
Download a US regions cartographic boundary shapefile into R
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

us_regions <- regions(resolution = '20m')

leaflet(us_regions) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
Other national cartographic boundary functions: \code{\link{divisions}},
  \code{\link{nation}}
}
\concept{national cartographic boundary functions}
