% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_param.R
\name{trend_param}
\alias{trend_param}
\title{Tendencia monotona por parametro e ponto (Theil-Sen + Spearman)}
\usage{
trend_param(
  data,
  param,
  date_col = "data",
  group_cols = c("rio", "ponto"),
  min_n = 6,
  alpha = 0.05
)
}
\arguments{
\item{data}{data.frame com pelo menos uma coluna de data e a coluna do parametro.}

\item{param}{nome do parametro (string), por exemplo "turbidez" ou "iqa".}

\item{date_col}{nome da coluna de datas. Default: "data".}

\item{group_cols}{vetor de nomes para agrupar. Default: c("rio","ponto").}

\item{min_n}{amostra minima por grupo. Default: 6.}

\item{alpha}{nivel de significancia para classificar tendencia. Default: 0.05.}
}
\value{
data.frame com colunas por grupo e:
n, date_min, date_max, days_span, slope_per_year, intercept,
rho_spearman, p_value, trend ("aumento" / "queda" / "estavel"),
pct_change_period (aprox. \% no periodo observado).
}
\description{
Calcula a inclinacao de Theil-Sen (robusta) e o p-valor do teste
de correlacao de Spearman entre tempo e o valor do parametro.
Retorna estatisticas por grupo (ex.: rio, ponto).
}
\examples{
set.seed(1)
df <- data.frame(
  data = as.Date("2024-01-01") + 0:11*30,
  rio = "Demo", ponto = "P1",
  turbidez = 20 + (-0.3)*(0:11) + rnorm(12, 0, 1)
)
trend_param(df, param = "turbidez")
}
