% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VFS.R
\name{tiledb_vfs_is_bucket}
\alias{tiledb_vfs_is_bucket}
\title{Check for VFS Bucket}
\usage{
tiledb_vfs_is_bucket(uri, vfs = tiledb_get_vfs())
}
\arguments{
\item{uri}{Character variable with a URI describing a cloud bucket}

\item{vfs}{A TileDB VFS object; default is to use a cached value.}
}
\value{
A boolean value indicating if it is a valid bucket
}
\description{
Check for VFS Bucket
}
\examples{
\dontshow{
ctx <- tiledb_ctx(limitTileDBCores())
}
\dontrun{
cfg <- tiledb_config()
cfg["vfs.s3.region"] <- "us-west-1"
ctx <- tiledb_ctx(cfg)
vfs <- tiledb_vfs()
tiledb_vfs_is_bucket(vfs, "s3://tiledb-public-us-west-1/test-array-4x4")
}
}
