% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossed_join.R
\name{crossed_join}
\alias{crossed_join}
\title{A \code{do.call()} and \code{data.table::CJ()} method}
\usage{
crossed_join(
  X,
  sort = FALSE,
  unique = TRUE,
  as_dt = TRUE,
  strings_as_factors = FALSE,
  log_limit = 8
)
}
\arguments{
\item{X}{A list or data frame.}

\item{sort}{Should the expansion be sorted? By default it is \code{FALSE}.}

\item{unique}{Should unique values across each column or list element
be taken? By default this is \code{TRUE}.}

\item{as_dt}{Should result be a \code{data.table}?
By default this is \code{TRUE}. If \code{FALSE} a list is returned.}

\item{strings_as_factors}{Should strings be converted to factors before
expansion? The default is \code{FALSE} but setting to \code{TRUE} can offer
a significant speed improvement.}

\item{log_limit}{The maximum log10 limit for expanded number of rows.
Anything >= this results in an error.}
}
\value{
A data.table or list object.
}
\description{
This function operates like \code{do.call(CJ, ...)} and accepts
a list or data.frame as an argument. \cr
It has less overhead for small joins, especially when \code{unique = FALSE} and
\code{as_dt = FALSE}. \cr
\code{NA}s are by default sorted last.
}
\details{
An important note is that currently \code{NA}s
are sorted last and therefore a key is not set.
}
\examples{
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
crossed_join(list(1:3, -2:2))
crossed_join(iris)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
