% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_aggregate.R
\name{time_aggregate}
\alias{time_aggregate}
\title{Aggregate time to a higher unit}
\usage{
time_aggregate(
  x,
  time_by = NULL,
  g = NULL,
  time_type = getOption("timeplyr.time_type", "auto"),
  roll_month = getOption("timeplyr.roll_month", "preday"),
  roll_dst = getOption("timeplyr.roll_dst", "boundary"),
  direction = c("l2r", "r2l")
)
}
\arguments{
\item{x}{Time vector. \cr
Can be a \code{Date}, \code{POSIXt}, \code{numeric}, \code{integer},
\code{yearmon}, or \code{yearqtr} vector.}

\item{time_by}{Time unit. \cr
Must be one of the following:
\itemize{
\item string, e.g \code{time_by = "day"} or \code{time_by = "2 weeks"}
\item lubridate duration or period object, e.g. \code{days(1)} or \code{ddays(1)}.
\item named list of length one, e.g. \code{list("days" = 7)}.
\item Numeric vector, e.g. \code{time_by = 7}.
}}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks, months or years are specified,
and \code{durations} are used otherwise.}

\item{roll_month}{Control how impossible dates are handled when
month or year arithmetic is involved.}

\item{roll_dst}{See \code{?timechange::time_add} for the full list of details.}

\item{direction}{Direction with which to aggregate time,
"l2r" ("left-to-right") or "r2l" ("right-to-left").
If "l2r" (the default), then the minimum time is used as the
reference time, otherwise the maximum time is used.}
}
\value{
A time aggregated vector the same class and length as \code{x}.
}
\description{
Aggregate time to a higher unit for possibly many groups
with respect to a time index.
}
\details{
\code{time_aggregate} aggregates time using
distinct moving time range blocks of a specified time unit.

The actual calculation is extremely simple and essentially requires
a subtraction, a rounding and an addition.

If for example \code{time_by = "week"} then all dates or datetimes
will be shifted backwards (or forwards if direction is "r2l") to the
nearest start of the week, where the start of week is based on \code{min(x)}.
This is identical to building a weekly sequence and using this as
breakpoints to cut \code{x}. No time expansion occurs so this is very efficient
except when \code{periods} are used and there is a lot of data.
In this case, provided the expansion is not too big,
it may be more efficient to cut the data using the period sequence which can
be achieved using \code{time_summarisev}.
}
\examples{
library(timeplyr)
library(nycflights13)
library(lubridate)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
sunique <- function(x) sort(unique(x))

hours <- sunique(flights$time_hour)
days <- as_date(hours)

# Aggregate by week or any time unit easily
unique(time_aggregate(hours, "week"))
unique(time_aggregate(hours, ddays(14)))
unique(time_aggregate(hours, "month"))
unique(time_aggregate(days, "month"))

# Left aligned
unique(time_aggregate(days, "quarter"))
# Right aligned
unique(time_aggregate(days, "quarter", direction = "r2l"))

# Very fast by group aggregation
week_by_tailnum <- time_aggregate(flights$time_hour, time_by = ddays(7),
                                  g = flights$tailnum)
# Confirm this has been done by group as each group will have a
# Different aggregate start date
flights \%>\%
  mutate(week_by_tailnum) \%>\%
  stat_summarise(week_by_tailnum, .by = tailnum, stat = "min",
                 sort = FALSE)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
\seealso{
\link{time_summarisev}
}
