% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_distinct.R
\name{time_distinct}
\alias{time_distinct}
\title{A time based extension to \code{dplyr::distinct()}.}
\usage{
time_distinct(
  data,
  time = NULL,
  ...,
  time_by = NULL,
  from = NULL,
  to = NULL,
  .keep_all = FALSE,
  time_type = getOption("timeplyr.time_type", "auto"),
  include_interval = FALSE,
  .by = NULL,
  time_floor = FALSE,
  week_start = getOption("lubridate.week.start", 1),
  roll_month = getOption("timeplyr.roll_month", "preday"),
  roll_dst = getOption("timeplyr.roll_dst", "boundary"),
  sort = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{time}{Time variable.}

\item{...}{Additional variables to include.}

\item{time_by}{Time unit. \cr
Must be one of the three:
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{from}{Time series start date.}

\item{to}{Time series end date.}

\item{.keep_all}{If \code{TRUE} then all columns of data frame are kept,
default is \code{FALSE}.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks, months or years are specified,
and \code{durations} are used otherwise.}

\item{include_interval}{Logical. If \code{TRUE} then
a column "interval" of the form \verb{time_min <= x < time_max} is added
showing the time interval in which the respective counts belong to.
The rightmost interval will always be closed.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{time_floor}{Should \code{from} be floored to the nearest unit
specified through the \code{time_by}
argument? This is particularly useful for starting
sequences at the beginning of a week
or month for example.}

\item{week_start}{day on which week starts following ISO conventions - 1
means Monday, 7 means Sunday (default).
This is only used when \code{time_floor = TRUE}.}

\item{roll_month}{Control how impossible dates are handled when
month or year arithmetic is involved.
Options are "preday", "boundary", "postday", "full" and "NA".
See \code{?timechange::time_add} for more details.}

\item{roll_dst}{See \code{?timechange::time_add} for the full list of details.}

\item{sort}{Should the result be sorted? Default is \code{TRUE}.
If \code{FALSE} then original (input) order is kept.}
}
\value{
A \code{data.frame} of distinct aggregate time values across groups.
}
\description{
This works much the same as \code{dplyr::distinct()}, except that
you can supply an additional \code{time} argument to allow for
aggregating time to a higher unit.
}
