% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/resolveOverlap.R
\name{resolveOverlap}
\alias{resolveOverlap}
\title{Concatenate Time Series and Resolve Overlap Automatically}
\usage{
resolveOverlap(ts1, ts2, keep_ts2 = T)
}
\arguments{
\item{ts1}{ts time series, typically the older series}

\item{ts2}{ts time series, typically the younger series}

\item{keep_ts2}{logical should ts2 be kept? Defaults to TRUE.}
}
\description{
Append time series to each other. Resolve overlap determines
 which of two ts class time series is
reaching further and arranges the two series into first and second
series accordingly. Both time series are concatenated to one
if both series had the same frequency. Typically this function is used
concatenate two series that have a certain overlap, but one series clearly
starts earlier while the other lasts longer. If one series starts earlier and
stops later, all elements of the shorter series will be inserted into the
larger series, i.e. elements of the smaller series will replace the elements
of the longer series. Usually ts2 is kept.
}
\examples{
ts1 <- ts(rnorm(100),start = c(1990,1),frequency = 4)
ts2 <- ts(1:18,start = c(2000,1),frequency = 4)
resolveOverlap(ts1,ts2)

# automatical detection of correction sequence!
ts1 <- ts(rnorm(90),start = c(1990,1),frequency = 4)
ts2 <- ts(1:60,start = c(2000,1),frequency = 4)
resolveOverlap(ts1,ts2)

# both series are of the same length use sequence of arguments.
ts1 <- ts(rnorm(100),start = c(1990,1),frequency = 4)
ts2 <- ts(1:48,start = c(2003,1),frequency = 4)
resolveOverlap(ts1,ts2)
ts1 <- ts(rnorm(101),start = c(1990,1),frequency = 4)
ts2 <- ts(1:61,start = c(2000,1),frequency = 4)
resolveOverlap(ts1,ts2)
#' clearly dominatn ts2 series
ts1 <- ts(rnorm(50),start = c(1990,1),frequency = 4)
ts2 <- ts(1:100,start = c(1990,1),frequency = 4)
resolveOverlap(ts1,ts2)
}

