% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsSetFunctions.R
\name{joinTsSets}
\alias{joinTsSets}
\title{Join two Time Series sets together}
\usage{
joinTsSets(con, set_name_1, set_name_2, set_name_new,
  user_name1 = Sys.info()["user"], user_name2 = user_name1,
  user_name_new = user_name1, description = NULL, active = NULL,
  tbl = "timeseries_sets", schema = "timeseries")
}
\arguments{
\item{con}{PostgreSQL connection}

\item{set_name_1}{Name of the first set}

\item{set_name_2}{Name of the second set}

\item{set_name_new}{Name of the set to be created}

\item{user_name1}{User name of the first set's owner}

\item{user_name2}{User name of the second set's owner}

\item{user_name_new}{User name of the new set's owner}

\item{description}{Description of the new set}

\item{active}{Should the new set be marked as active}

\item{tbl}{The time series set table}

\item{schema}{The time series db schema to use}
}
\description{
This will create a new set set_name_new with the keys from both 
set_name_1 and set_name_2 combined.
By default the description will be a combination of the descriptions
of the subsets and the new set will only be active it BOTH subsets
were active.
}
\author{
Severin Thöni
}
