% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-scales.R
\name{axis.tind}
\alias{axis.tind}
\title{Add Time Axis --- Plotting with \code{graphics} Package}
\usage{
axis.tind(
  side,
  x,
  at,
  format = NULL,
  locale = NULL,
  labels = TRUE,
  n.breaks = 5L,
  ...
)
}
\arguments{
\item{side}{see \code{\link[graphics]{axis}}.}

\item{x}{time indices for which an axis is to be created.}

\item{at}{(optional) time indices at which manual tick-marks and labels
should be placed.}

\item{format}{(optional) a character string determining label format
or a formatting function, see \code{\link{format}}.}

\item{locale}{(optional) a character string determining locale to be used
for formatting labels, see \link{calendar-names} for information
on locale settings.}

\item{labels}{a logical value determining whether automatic labels should
be placed at tick-marks or a character vector of labels.}

\item{n.breaks}{an integer value, desired number of breaks.}

\item{...}{further arguments passed to \code{\link[graphics]{axis}}.}
}
\value{
Same as for \code{\link[graphics]{axis}}, used for its side effect,
which is to add time axis to an existing plot.
}
\description{
\code{axis.tind} adds time axis to a plot. Axes will be added automatically
by \pkg{graphics}, but the default behaviour can be overridden by plotting
without axis and then calling \code{axis.tind}, see Examples.
}
\examples{
\donttest{
# load graphics
library(graphics)
# artificial data
N <- 100
df <- data.frame(d = today() + (-N + 1):0, y = cumsum(rnorm(N)))
# default axis
plot(df$d, df$y, type = "l")
# custom date format with potentially more breaks and a smaller font
plot(df$d, df$y, type = "l", xaxt = "n")
axis.tind(1, df$d, format = "\%m/\%d/\%y", n.breaks = 7L, cex.axis = .9)
}

}
\seealso{
\code{\link{pretty}} for computing pretty breakpoints,
\code{\link{axis_t}} for calculating axis parameters,
\code{\link{scale_tind}} for creating axes with \pkg{ggplot2}.
}
