% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{date2num}
\alias{date2num}
\alias{num2date}
\title{Conversion between Dates and Their Integer Representations}
\usage{
date2num(x, format)

num2date(x, format)
}
\arguments{
\item{x}{a \code{tind} with dates or an integer vector.}

\item{format}{a character value determing numeric representation of date;
currently, the following are supproted: \code{"R"},
\code{"MATLAB"}, \code{"Excel"}, \code{"SAS"},
\code{"JDN"} (Julian Day Number).}
}
\value{
\code{date2num} returns an integer vector
and \code{num2date} returns \code{tind} representing dates.
}
\description{
\code{date2num} and \code{num2date} support conversion between
\code{tind} dates and integer representations of dates (days since ...)
found in different software packages.
}
\examples{
(td <- today())
fmts <- c("R", "MATLAB", "Excel", "SAS", "JDN")
(n <- sapply(fmts, function(fmt) date2num(td, fmt)))
lapply(fmts, function(fmt) num2date(n[fmt], fmt))

}
\seealso{
\code{\link{jdn}} for description of Julian Day Numbers.
}
