% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{time-index-components}
\alias{time-index-components}
\alias{year}
\alias{quarter}
\alias{quarters.tind}
\alias{month}
\alias{months.tind}
\alias{week}
\alias{day}
\alias{day_of_year}
\alias{day_of_week}
\alias{weekdays.tind}
\alias{hour}
\alias{am}
\alias{pm}
\alias{minute}
\alias{second}
\title{Time Index Components (Years, Months, Days, ...)}
\usage{
year(x)

quarter(x)

\method{quarters}{tind}(x, abbreviate)

month(x, labels = FALSE, abbreviate = TRUE, locale = NULL)

\method{months}{tind}(x, abbreviate = FALSE)

week(x)

day(x)

day_of_year(x)

day_of_week(x, labels = FALSE, abbreviate = TRUE, locale = NULL)

\method{weekdays}{tind}(x, abbreviate = FALSE)

hour(x)

am(x)

pm(x)

minute(x)

second(x)
}
\arguments{
\item{x}{an object of \code{tind} class or an R object coercible to it.}

\item{abbreviate}{a logical value, if \code{TRUE}, abbreviated names are returned;
if \code{FALSE}, full names are returned.
\code{TRUE} by default.}

\item{labels}{a logical value, if \code{TRUE} month and weekday names are
returned (as ordered factors) instead of integer indices (\code{FALSE}
by default).}

\item{locale}{(optional) a character value determining locale or \code{NULL}
(the default, interpreted as the current system locale),
see \link{calendar-names} for information on locale settings.}
}
\value{
All functions return integer vectors, except for \code{second}, which
returns numeric vectors. Additionally, \code{month} and \code{day_of_week}
return ordered factors if invoked with argument \code{labels} set to \code{TRUE}.
}
\description{
The following functions can be used to retrieve components of time indices.

\code{year}, \code{quarter}, \code{month}, \code{week}, \code{day} return
year (0--9999), quarter (1--4), month (1--12), week (1--53, ISO 8601),
and day (1--31) indices as integers. When \code{month} is invoked
with \code{labels} argument set to \code{TRUE}, an ordered factor is returned.

\code{day_of_week} returns index (1--7) of weekday with Monday as the first
day (as in ISO 8601). When invoked with \code{labels} argument
set to \code{TRUE}, an ordered factor is returned.

\code{day_of_year} returns index (1--366) of the day of year as integer.

\code{hour}, \code{minute}, \code{second} return hour (0--23),
minute (0--59), and second (0--59,999999) indices as integers and reals (for seconds).
\code{am} and \code{pm} functions determine whether time falls in the first
or second half of the day.

Methods \code{weekdays}, \code{months}, and \code{quarters} from package \pkg{base}
are implemented but users are encouraged to use functions from \pkg{tind} package.
}
\details{
\code{year} for week arguments need not necessarily return the same value
as for days within the week in question when the week is the first or the last
in a year.

\pkg{tind} package does not provide replacement methods for time index components.
In order to change, say, month one can use \code{tind} constructor or \code{\%+m\%}
operator (and similar operators), see Examples.
}
\examples{
# current date and time
(nw <- now())
# show current year, quarter, month, ...
year(nw)
quarter(nw)
month(nw)
month(nw, labels = TRUE)
month(nw, labels = TRUE, abbreviate = FALSE)
week(nw)
day(nw)
day_of_week(nw)
day_of_week(nw, labels = TRUE)
day_of_week(nw, labels = TRUE, abbreviate = FALSE)
day_of_year(nw)
hour(nw)
minute(nw)
second(nw)

# alternatives to replacement, change month to December
(x <- as.date("2023-09-11"))
(x <- tind(y = year(x), m = 12, d = day(x)))
(x <- as.date("2023-09-11"))
(x <- x \%+m\% (12 - month(x)))

}
\seealso{
\code{\link{tind}} class, \link{Ops}
for index increments / decrements and index differences, and
\link{calendar-names} for names of months and days of weeks in the current
locale. Further examples of use of these functions can be found
in \code{\link{calendar}} documentation.
}
