% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{time-index-properties}
\alias{time-index-properties}
\alias{is.leap_year}
\alias{days_in_year}
\alias{weeks_in_year}
\alias{days_in_quarter}
\alias{days_in_month}
\alias{hours_in_day}
\alias{is.dst}
\title{Time Index Properties (Leap Years, Period Lengths, DST)}
\usage{
is.leap_year(x)

days_in_year(x)

weeks_in_year(x)

days_in_quarter(x)

days_in_month(x)

hours_in_day(x, tz = NULL)

is.dst(x)
}
\arguments{
\item{x}{an object of \code{tind} class or an R object coercible to it.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}
}
\value{
\code{is.leap_year} and \code{is.dst} return logical vectors.
The remaining functions return integer vectors, except for \code{hours_in_day},
which returns numeric vectors.
}
\description{
The following functions can be used to determine whether years are leap
years, compute the number of subperiods within a period, and determine
whether Daylight Saving Time is on for particular date-time index.
All function are vectorised.

\code{is.leap_year} returns \code{TRUE} for leap years and \code{FALSE} for
non-leap ones.

\code{days_in_year} and \code{weeks_in_year} return the number of days
(365--366) and the number of weeks (52--53) in a year.

\code{days_in_quarter} and \code{days_in_month} return the number of days
in a quarter (90--92) or a month (28--31), respectively.

\code{hours_in_day} returns the number of hours in a day (24 most
of the time, a different number during DST/UTC offset changes).

\code{is.dst} returns \code{TRUE} when Daylight Saving Time is on
and \code{FALSE} otherwise.
}
\seealso{
\link{time-index-components}, \link{calendrical-computations},
\link{Ops}, \code{\link{tzone}}, \code{\link{bizdays_in_month}}.
}
