% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{tind-coercion}
\alias{tind-coercion}
\alias{as.integer.tind}
\alias{as.double.tind}
\alias{as.character.tind}
\alias{as.Date.tind}
\alias{as.POSIXct.tind}
\alias{as.POSIXlt.tind}
\alias{as.data.frame.tind}
\title{Conversion of Objects of \code{tind} Class}
\usage{
\method{as.integer}{tind}(x, ...)

\method{as.double}{tind}(x, ...)

\method{as.character}{tind}(x, ...)

\method{as.Date}{tind}(x, ...)

\method{as.POSIXct}{tind}(x, tz = NULL, ...)

\method{as.POSIXlt}{tind}(x, tz = NULL, ...)

\method{as.data.frame}{tind}(x, ...)
}
\arguments{
\item{x}{an object of \code{tind} class.}

\item{...}{further arguments passed to or from other methods.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}
}
\value{
\code{as.xxx} returns an object of \code{xxx} class of the same
length as the argument. \code{as.data.frame} returns a data frame with a single
column and the number of rows equal to the length of the argument.
}
\description{
Objects of \code{tind} class can be easily converted to built-in R classes
inluding \code{numeric}, \code{integer}, \code{character}, \code{Date},
\code{POSIXct}, \code{POSIXlt}, and \code{data.frame}.
}
\details{
\code{as.double} and \code{as.numeric} return internal representation
for particular time index type (seconds, days, weeks etc. since ...).

For years, quarters, months, weeks, and dates, \code{as.integer} returns
representation in the form \code{YYYY}, \code{YYYYQ}, \code{YYYYMM}, \code{YYYYWW},
and \code{YYYYMMDD}, respectively. For other index types, \code{as.integer}
returns internal representation of time indices converted to integer.

\code{as.character} returns character vector with standard (ISO 8601)
representation of time indices. For customisable output formats,
see \code{\link{format}}.

\code{as.Date}, \code{as.POSIXct}, and \code{as.POSIXlt} return objects
of classes \code{Date}, \code{POSIXct}, and \code{POSIXlt}, respectively.

\code{as.data.frame} returns a 1-column data frame with time indices and
allows to work with time indices in data frames.
}
\seealso{
\code{\link{format}} for customisable character output formats,
\code{\link{as.tind}} for conversion to \code{tind}.
For conversions between \code{tind} class and other classes (from packages
other than \pkg{base}), see \link{tind-other}.
}
