% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_int.R
\name{write_int}
\alias{write_int}
\title{Format an interval for display}
\usage{
write_int(x, delim = "(", digits = 2)
}
\arguments{
\item{x}{A length-2 numeric vector consisting of the endpoints of the interval or an n-row by 2-column matrix of endpoints.}

\item{delim}{The bracket delimiters to surround the interval. Must be either a round bracket, square bracket, curly bracket, or angled bracket.}

\item{digits}{Number of digits to round to (default to 2). Will keep trailing zeros.}
}
\value{
Returns a character string of the form "(x[1], x[2])" (or supplied bracket delimiter).
}
\description{
\code{write_int} formats a numeric input into an interval to be printed, e.g., in an RMarkdown document.
}
\details{
If a matrix is provided, the values in each row will be used to create a formatted interval.
}
\examples{
write_int(x=c(1.2, 2.345))
write_int(x=c(1.2, 2.345), delim='[')

}
