% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_densities.R
\name{calc_densities}
\alias{calc_densities}
\title{Calculate densities}
\usage{
calc_densities(shp, var, unit = "km", unit.size = 1000, total.area = NA,
  suffix = "", drop = TRUE)
}
\arguments{
\item{shp}{a shape object, i.e., a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}

\item{var}{name(s) of a qualtity variable name contained in the \code{shp} data}

\item{unit}{the preferred unit, for instance, "km", "m", or "miles". Density values are calculated in \code{var/unit^2}.}

\item{unit.size}{size of the unit in terms of coordinate units. The coordinate system of many projections is approximately in meters while thematic maps typically range many kilometers, so by default \code{unit="km"} and \code{unit.size=1000} (meaning 1 kilometer equals 1000 coordinate units).}

\item{total.area}{total area size of \code{shp} in number of squared units (by default kilometers). Useful if the total area of the \code{shp} differs from a reference total area value.}

\item{suffix}{character that is appended to the variable names. The resulting names are used as column names of the returned data.frame.}

\item{drop}{boolean that determines whether an one-column data-frame should be returned as a vector}
}
\value{
Vector or data.frame (depending on whether \code{length(var)==1} with density values. This can be appended directly to the shape file with \code{\link{append_data}} with \code{fixed.order=TRUE}.
}
\description{
Transpose quantitative variables to densitiy variables, which are often needed for choroplets. For example, the colors of a population density map should correspond population density counts rather than absolute population numbers.
}
\examples{
data(NLD_muni)

NLD_muni_pop_per_km2 <- calc_densities(NLD_muni, 
    var = c("pop_men", "pop_women"), suffix = "_km2")
NLD_muni <- append_data(NLD_muni, NLD_muni_pop_per_km2, fixed=TRUE)

tm_shape(NLD_muni) +
	tm_polygons(c("pop_men_km2", "pop_women_km2"), 
        title=expression("Population per " * km^2), style="quantile") +
tm_facets(free.scales = FALSE) +
tm_layout(panel.show = TRUE, panel.labels=c("Men", "Women"))
	
}
\keyword{densities}

