% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{tmap-element}
\alias{tmap-element}
\title{tmap element}
\description{
Building block for drawing thematic maps. All element functions have the prefix \code{tm_}.
}
\details{
The fundamental, and hence required element is
\itemize{
\item \code{\link{tm_shape}} that specifies the shape object, and also specifies the projection and bounding box}

The elements that serve as aesthetics layers are
\itemize{
\item \code{\link{tm_fill}} to fill the polygons
\item \code{\link{tm_borders}} to draw polygon borders
\item \code{\link{tm_polygons}} to draw polygons (it is a combination of \code{\link{tm_fill}} and \code{\link{tm_borders}})
\item \code{\link{tm_bubbles}} to draw bubbles
\item \code{\link{tm_lines}} to draw lines
\item \code{\link{tm_text}} to add text annotations
\item \code{\link{tm_raster}} to draw a raster}

The layers can be stacked by simply adding them with the + symbol. The combination of the elements described above form one group. Multiple groups can be stacked. Each group should start with \code{\link{tm_shape}}.

The attribute elements are
\itemize{
\item \code{\link{tm_grid}} to specify coordinate grid lines
\item \code{\link{tm_credits}} to add a credits/acknowledgements text label
\item \code{\link{tm_scale_bar}} to add a measurement scale bar
\item \code{\link{tm_compass}} to add a map compass
}

The element \code{\link{tm_facets}} specifies facets (small multiples). The element \code{\link{tm_layout}} is used to change the layout of the map.
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}

\href{../doc/tmap-modes.html}{\code{vignette("tmap-modes")}}

The examples in each of the element functions
}

