% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_compass}
\alias{tm_compass}
\title{Map component: compass}
\usage{
tm_compass(
  north,
  type,
  text.size,
  size,
  show.labels,
  cardinal.directions,
  text.color,
  color.dark,
  color.light,
  lwd,
  position,
  bg.color,
  bg.alpha,
  stack,
  just,
  frame,
  frame.lwd,
  frame.r,
  margins,
  z,
  ...
)
}
\arguments{
\item{north}{north}

\item{type}{compass type, one of: \code{"arrow"}, \code{"4star"}, \code{"8star"}, \code{"radar"}, \code{"rose"}. The default is controlled by \code{\link{tm_layout}} (which uses \code{"arrow"} for the default style)}

\item{text.size}{text.size}

\item{size}{size}

\item{show.labels}{show.labels}

\item{cardinal.directions}{cardinal.directions}

\item{text.color}{text.color}

\item{color.dark}{color.dark}

\item{color.light}{color.light}

\item{lwd}{lwd}

\item{position}{An object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}.}

\item{bg.color}{Background color}

\item{bg.alpha}{Background transparency}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{just}{just}

\item{frame}{frame}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{margins}{margins}

\item{z}{z}

\item{...}{to catch deprecated arguments (alpha)}
}
\description{
Map component that adds a compass
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_components}{Vignette about components}
}
