% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DatNetClass.R
\docType{class}
\name{DatNet.sWsA}
\alias{DatNet.sWsA}
\title{R6 class for storing and managing the combined summary measures \code{sW} & \code{sA} from DatNet classes.}
\format{An \code{\link{R6Class}} generator object}
\usage{
DatNet.sWsA
}
\description{
This class inherits from \code{DatNet} and extends its methods to handle a single matrix dataset of
 all summary measures \code{(sA,sW)}
 The class \code{DatNet.sWsA} is the only way to access data in the entire package.
 Contains methods for combining, subsetting, discretizing & binirizing summary measures \code{(sW,sA)}.
 For continous sVar this class provides methods for detecting / setting bin intervals,
 normalization, disretization and construction of bin indicators.
 The pointers to this class get passed on to \code{SummariesModel} functions: \code{$fit()},
 \code{$predict()} and \code{$predictAeqa()}.
}
\details{
\itemize{
\item{\code{datnetW}} - .
\item{\code{datnetA}} - .
\item{\code{active.bin.sVar}} - Currently discretized continous \code{sVar} column in data matrix \code{mat.sVar}.
\item{\code{mat.bin.sVar}} - Matrix of the binary indicators for discretized continuous covariate \code{active.bin.sVar}.
\item{\code{ord.sVar}} - Ordinal (categorical) transformation of a continous covariate \code{sVar}.
\item{\code{YnodeVals}} - .
\item{\code{det.Y}} - .
\item{\code{p}} - .
}
}
\section{Methods}{

\describe{
  \item{\code{new(datnetW, datnetA, YnodeVals, det.Y, ...)}}{...}
  \item{\code{addYnode(YnodeVals, det.Y)}}{...}
  \item{\code{evalsubst(subsetexpr, subsetvars)}}{...}
  \item{\code{get.dat.sWsA(rowsubset = TRUE, covars)}}{...}
  \item{\code{get.outvar(rowsubset = TRUE, var)}}{...}
  \item{\code{copy.sVar.types()}}{...}
  \item{\code{bin.nms.sVar(name.sVar, nbins)}}{...}
  \item{\code{pooled.bin.nm.sVar(name.sVar)}}{...}
  \item{\code{detect.sVar.intrvls(name.sVar, nbins, bin_bymass, bin_bydhist, max_nperbin)}}{...}
  \item{\code{detect.cat.sVar.levels(name.sVar)}}{...}
  \item{\code{discretize.sVar(name.sVar, intervals)}}{...}
  \item{\code{binirize.sVar(name.sVar, intervals, nbins, bin.nms)}}{...}
  \item{\code{binirize.cat.sVar(name.sVar, levels)}}{...}
  \item{\code{get.sVar.bw(name.sVar, intervals)}}{...}
  \item{\code{get.sVar.bwdiff(name.sVar, intervals)}}{...}
  \item{\code{make.dat.sWsA(p = 1, f.g_fun = NULL, sA.object = NULL)}}{...}
}
}

\section{Active Bindings}{

\describe{
   \item{\code{dat.sWsA}}{...}
   \item{\code{dat.bin.sVar}}{...}
   \item{\code{emptydat.bin.sVar}}{...}
   \item{\code{names.sWsA}}{...}
   \item{\code{nobs}}{...}
   \item{\code{noNA.Ynodevals}}{...}
   \item{\code{nodes}}{...}
}
}
\keyword{R6}
\keyword{class}

