% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{makeTmod}
\alias{makeTmod}
\alias{tmod-class}
\title{S4 class for tmod}
\usage{
makeTmod(modules, modules2genes, genes2modules = NULL, genes = NULL)
}
\arguments{
\item{modules}{A data frame with at least columns ID and Title}

\item{modules2genes}{A list with module IDs as names. Each member of the list is a character vector with IDs of genes contained in that module}

\item{genes2modules}{A list with gene IDs as names. Each member of the list is a character vector with IDs of modules in
which that gene is contained. This object will be created automatically if the provided parameter is NULL}

\item{genes}{A data frame with meta-information on genes. Must contain the column ID. If NULL, then a data frame with only one column (ID) will be created automatically.}
}
\description{
S4 class for tmod
}
\details{
An object of class tmod contains the module annotations (tmod$MODULES), gene to
module (tmod$GENES2MODULES) and module to gene (tmod$MODULES2GENES) mappings
and a gene list (tmod$GENES).

tmod$MODULES and tmod$GENES are data frames, while tmod$MODULES2GENES and
tmod$GENES2MODULES are lists with, respectively, module and gene
identifiers as names. The data frames MODULES and GENES must contain the
column "ID", and the data frame MODULES must contain additionally the
column "Title".

Objects of class tmod should be constructed
by calling the function makeTmod(). This function check the validity and
consistency of the provided objects, and, if necessary, automatically
creates the members GENES and GENES2MODULES.

See the package vignette for more on constructing custom module sets.
}
\examples{
# A minimal example
m <- data.frame(ID=letters[1:3], Title=LETTERS[1:3])
m2g <- list(a=c("g1", "g2"), b=c("g3", "g4"), c=c("g1", "g2", "g4"))
mymset <- makeTmod(modules=m, modules2genes=m2g)
}
\seealso{
tmod-data
}

