% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_model}
\alias{build_model}
\alias{build_model.default}
\alias{build_model.matrix}
\alias{build_model.stslist}
\alias{build_model.data.frame}
\alias{build_model.tna_data}
\alias{tna}
\alias{ftna}
\alias{ctna}
\title{Build a Transition Network Analysis Model}
\usage{
build_model(x, type = "relative", scaling = character(0L), ...)

\method{build_model}{default}(
  x,
  type = "relative",
  scaling = character(0L),
  inits,
  params = list(),
  ...
)

\method{build_model}{matrix}(x, type = "relative", scaling = character(0L), inits, ...)

\method{build_model}{stslist}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = seq(1, ncol(x)),
  params = list(),
  ...
)

\method{build_model}{data.frame}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = seq(1, ncol(x)),
  params = list(),
  ...
)

\method{build_model}{tna_data}(x, type = "relative", scaling = character(0), params = list(), ...)

tna(x, ...)

ftna(x, ...)

ctna(x, ...)
}
\arguments{
\item{x}{A \code{stslist} (from \code{TraMineR}), \code{data.frame}, a \code{matrix}, or
a \code{tna_data} object (see \code{\link[=prepare_data]{prepare_data()}}).
For \code{stslist} and \code{data.frame} objects \code{x}
should describe a sequence of events or states to be used for building the
Markov model.  If \code{x} is a matrix, it is assumed that the element on row
\code{i} and column \code{j} is the weight of the edge representing the transition
from state \code{i} to state \code{j}. If \code{x} is a \code{data.frame}, then
it must be in wide format (see \code{cols} on how to define columns for the
time points).}

\item{type}{A \code{character} string describing the weight matrix type.
Currently supports the following types:
\itemize{
\item \code{"relative"} for relative frequencies (probabilities, the default)
\item \code{"frequency"} for frequencies.
\item \code{"co-occurrence"} for co-occurrences.
\item \code{"n-gram"} for n-gram transitions. Captures higher-order transitions by
considering sequences of n states, useful for identifying longer
patterns.
\item \code{"gap"} allows transitions between non-adjacent states, with
transitions weighted by the gap size.
\item \code{"window"} creates transitions between all states within a
sliding window, capturing local relationships
(several sequences together).
\item \code{"reverse"} considers the sequences in reverse order
(resulting in what is called a reply network in some contexts).
The resulting weight matrix is the transpose of the \code{"frequency"}
option.
}}

\item{scaling}{A \code{character} vector describing how to scale the weights
defined by \code{type}. When a vector is provided, the scaling options are
applied in the respective order. For example, \code{c("rank", "minmax")} would
first compute the ranks, then scale them to the unit interval using
min-max normalization. An empty vector corresponds to no scaling.
Currently supports the following options:
\itemize{
\item \code{"minmax"} performs min-max normalization to scale the weights to the
unit interval. Note that if the smallest weight is positive, it
will be zero after scaling.
\item \code{"max"} Multiplies the weights by the reciprocal of the largest weight
to scale the weights to the unit interval. This options preserves
positive ranks, unlike \code{"minmax"} when all weights are positive.
\item \code{"rank"} Computes the ranks of the weights using \code{\link[base:rank]{base::rank()}} with
\code{ties.method = "average"}.
}}

\item{...}{Ignored.}

\item{inits}{An optional \code{numeric} vector of initial state probabilities
for each state. Can be provided only if \code{x} is a \code{matrix}. The vector will
be scaled to unity.}

\item{params}{A \code{list} of additional arguments for models of specific
\code{type}. The potential elements of this list are:
\itemize{
\item \code{n_gram}: An \code{integer} for n-gram transitions specifying the number of
adjacent events. The default value is 2.
\item \code{max_gap}: An \code{integer} for the gap-allowed transitions specifying the
largest allowed gap size. The default is 1.
\item \code{window_size}: An \code{integer} for the sliding window transitions
specifying the window size. The default is 2.
\item \code{weighted}: A \code{logical} value. If \code{TRUE}, the transitions
are weighted by the inverse of the sequence length. Can be used for
frequency, co-occurrence and reverse model types. The default is
\code{FALSE}.
}}

\item{cols}{An \code{integer}/\code{character} vector giving the indices/names of the
columns that should be considered as sequence data.
Defaults to all columns, i.e., \code{seq(1, ncol(x))}.}
}
\value{
An object of class \code{tna} which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights}: An adjacency \code{matrix} of the model (weight matrix).
\item \code{inits}: A \code{numeric} vector of initial values for each state.
For \code{matrix} type \code{x}, this element will be \code{NULL} if \code{inits} is not
directly provided
\item \code{labels}: A \code{character} vector of the state labels, or \code{NULL} if
there are no labels.
\item \code{data}: The original sequence data that has been converted to an
internal format used by the package when \code{x} is a \code{stslist} or a
\code{data.frame} object. Otherwise \code{NULL}.
}

An object of class \code{tna} which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights}: An adjacency \code{matrix} of the model (weight matrix).
\item \code{inits}: A \code{numeric} vector of initial values for each state.
For \code{matrix} type \code{x}, this element will be \code{NULL} if \code{inits} is not
directly provided
\item \code{labels}: A \code{character} vector of the state labels, or \code{NULL} if
there are no labels.
\item \code{data}: The original sequence data that has been converted to an
internal format used by the package when \code{x} is a \code{stslist} or a
\code{data.frame} object. Otherwise \code{NULL}.
}

An object of class \code{tna} which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights}: An adjacency \code{matrix} of the model (weight matrix).
\item \code{inits}: A \code{numeric} vector of initial values for each state.
For \code{matrix} type \code{x}, this element will be \code{NULL} if \code{inits} is not
directly provided
\item \code{labels}: A \code{character} vector of the state labels, or \code{NULL} if
there are no labels.
\item \code{data}: The original sequence data that has been converted to an
internal format used by the package when \code{x} is a \code{stslist} or a
\code{data.frame} object. Otherwise \code{NULL}.
}

An object of class \code{tna} which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights}: An adjacency \code{matrix} of the model (weight matrix).
\item \code{inits}: A \code{numeric} vector of initial values for each state.
For \code{matrix} type \code{x}, this element will be \code{NULL} if \code{inits} is not
directly provided
\item \code{labels}: A \code{character} vector of the state labels, or \code{NULL} if
there are no labels.
\item \code{data}: The original sequence data that has been converted to an
internal format used by the package when \code{x} is a \code{stslist} or a
\code{data.frame} object. Otherwise \code{NULL}.
}
}
\description{
Construct a transition network analysis (TNA) model from sequence data.
The function takes a data set of sequence of events or states as input and
builds a TNA model. It extracts the edge weights and initial probabilities
from the data along with the state labels. THe function also accepts weight
matrices and initial state probabilities directly.
}
\examples{
model <- build_model(group_regulation)
print(model)

model <- tna(group_regulation)

model <- ftna(group_regulation)

model <- ctna(group_regulation)

}
\seealso{
Core functions
\code{\link{centralities}()},
\code{\link{plot.tna}()},
\code{\link{plot.tna_centralities}()},
\code{\link{plot_compare}()}
}
\concept{core}
