% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna_centralities}
\alias{plot.group_tna_centralities}
\title{Plot Centrality Measures}
\usage{
\method{plot}{group_tna_centralities}(
  x,
  reorder = TRUE,
  ncol = 3,
  scales = c("free_x", "fixed"),
  colors,
  labels = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{group_tna_centralities} object.}

\item{reorder}{A \code{logical} value indicating whether to reorder the values
for each centrality in a descending order. The default is \code{TRUE}.}

\item{ncol}{Number of columns to use for the facets. The default is 3.}

\item{scales}{Either \code{"fixed"} or \code{"free_x"} (the default). If \code{"free_x"},
the horizontal axis is scaled individually in each facet. If \code{"fixed"},
the same values are used for all axes.}

\item{colors}{The colors for each node (default is the model colors
if the \code{tna} model object is passed, otherwise \code{"black"}).}

\item{labels}{A \code{logical} value indicating whether to show the centrality
numeric values. The default is \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object displaying a line chart for each centrality
with one line per cluster.
}
\description{
Plot Centrality Measures
}
\examples{
model <- group_model(engagement_mmm)
cm <- centralities(model)
plot(cm)

}
\seealso{
Centrality measure functions
\code{\link{betweenness_network}()},
\code{\link{centralities}()},
\code{\link{plot.tna_centralities}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.tna_centralities}()}
}
\concept{centralities}
