% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_team_box.R
\name{bart_team_box}
\alias{bart_team_box}
\title{Get Team Box Stats}
\usage{
bart_team_box(
  year = current_season(),
  team = NULL,
  conf = NULL,
  split = NULL,
  stat = "total"
)
}
\arguments{
\item{year}{Filters to year.}

\item{team}{Filters to team.}

\item{conf}{Filters to conf.}

\item{split}{Split to filter (see details).}

\item{stat}{Filters for agg. stats (total) or avg. stats (avg)}
}
\value{
Returns a tibble with the number of columns dependent on the year.
}
\description{
Returns aggregate team stats back to 2008
}
\details{
The `split` argument filters the results by split, explained below:
\describe{ \item{result}{Wins and losses} \item{location}{Game location}
\item{month}{Game month} \item{type}{Game type}}
}
\examples{
\donttest{bart_team_box(split='month', team='Duke')}
}
