% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram-tokenizers.R
\name{ngram-tokenizers}
\alias{ngram-tokenizers}
\alias{tokenize_ngrams}
\alias{tokenize_skip_ngrams}
\title{N-gram tokenizers}
\usage{
tokenize_ngrams(x, lowercase = TRUE, n = 3L, n_min = n,
  stopwords = character(), ngram_delim = " ", simplify = FALSE)

tokenize_skip_ngrams(x, lowercase = TRUE, n_min = 1, n = 3, k = 1,
  stopwords = character(), simplify = FALSE)
}
\arguments{
\item{x}{A character vector or a list of character vectors to be tokenized
into n-grams. If \code{x} is a character vector, it can be of any length,
and each element will be tokenized separately. If \code{x} is a list of
character vectors, each element of the list should have a length of 1.}

\item{lowercase}{Should the tokens be made lower case?}

\item{n}{The number of words in the n-gram. This must be an integer greater
than or equal to 1.}

\item{n_min}{This must be an integer greater than or equal to 1, and less
than or equal to \code{n}.}

\item{stopwords}{A character vector of stop words to be excluded from the
n-grams.}

\item{ngram_delim}{The separator between words in an n-gram.}

\item{simplify}{\code{FALSE} by default so that a consistent value is
returned regardless of length of input. If \code{TRUE}, then an input with
a single element will return a character vector of tokens instead of a
list.}

\item{k}{For the skip n-gram tokenizer, the maximum skip distance between
words. The function will compute all skip n-grams between \code{0} and
\code{k}.}
}
\value{
A list of character vectors containing the tokens, with one element
  in the list for each element that was passed as input. If \code{simplify =
  TRUE} and only a single element was passed as input, then the output is a
  character vector of tokens.
}
\description{
These functions tokenize their inputs into different kinds of n-grams. The
input can be a character vector of any length, or a list of character vectors
where each character vector in the list has a length of 1. See details for an
explanation of what each function does.
}
\details{
\describe{ \item{\code{tokenize_ngrams}:}{ Basic shingled n-grams. A
contiguous subsequence of \code{n} words. This will compute shingled n-grams
for every value of between \code{n_min} (which must be at least 1) and
\code{n}. } \item{\code{tokenize_skip_ngrams}:}{Skip n-grams. A subsequence
of \code{n} words which are at most a gap of \code{k} words between them. The
skip n-grams will be calculated for all values from \code{0} to \code{k}. } }

These functions will strip all punctuation and normalize all whitespace to a
single space character.
}
\examples{
song <-  paste0("How many roads must a man walk down\\n",
                "Before you call him a man?\\n",
                "How many seas must a white dove sail\\n",
                "Before she sleeps in the sand?\\n",
                "\\n",
                "How many times must the cannonballs fly\\n",
                "Before they're forever banned?\\n",
                "The answer, my friend, is blowin' in the wind.\\n",
                "The answer is blowin' in the wind.\\n")

tokenize_ngrams(song, n = 4)
tokenize_ngrams(song, n = 4, n_min = 1)
tokenize_skip_ngrams(song, n = 4, k = 2)
}
