% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{calculate_cumulative_distances}
\alias{calculate_cumulative_distances}
\title{Calculate Cumulative Distance Metrics}
\usage{
calculate_cumulative_distances(
  df_coords,
  ndim,
  reference_row = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{df_coords}{Data frame containing:
- V1...Vn coordinate columns
- year: Numeric years
- season: Character season identifiers.
- cluster: Factor cluster assignments
- color: Character color codes}

\item{ndim}{Number of coordinate dimensions}

\item{reference_row}{Integer index of reference row (or FALSE for all-pairs analysis)}

\item{na.rm}{Logical indicating whether to remove NA values}
}
\value{
A list containing the calculated distance metrics. The content of the list depends
on the \code{reference_row} parameter.
\itemize{
\item If \code{reference_row} is specified, the list contains \code{summary_data}: a \code{data.frame}
with distances from the specified reference point to all other points, summarized by
season and cluster. The columns include \code{season_num}, \code{cluster}, \code{color}, \code{avg_euclidean_dist},
\code{count}, \code{total_count}, and \code{fraction}.
\item If \code{reference_row} is \code{FALSE}, the list contains \code{dist_data}: a \code{data.frame} with all unique
pairwise distances. The columns include \code{year_diff}, \code{euclidean_dist}, and \code{ref_year}.
}
}
\description{
Calculates cumulative distance metrics either from a reference point or between
all pairs. Handles both seasonal and year-based analyses.
}
\examples{
# Create sample coordinate data
coords <- data.frame(V1 = rnorm(10), V2 = rnorm(10), year = rep(2000:2004, 2),
                     season = paste0(rep(2000:2004, 2), "-S"),
                     cluster = factor(rep(1:2, 5)), color = "blue")

# Calculate distances from reference point
ref_distances <- calculate_cumulative_distances(coords, ndim=2, reference_row=1)

# Calculate all pairwise distances
all_distances <- calculate_cumulative_distances(coords, ndim=2, reference_row=FALSE)

}
