% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{parameter_sensitivity_analysis}
\alias{parameter_sensitivity_analysis}
\title{Parameter Sensitivity Analysis}
\usage{
parameter_sensitivity_analysis(
  param,
  samples,
  bins = 30,
  mae_col = "Holdout_MAE",
  threshold_pct = 5,
  min_samples = 1
)
}
\arguments{
\item{param}{Character name of parameter to analyze}

\item{samples}{Data frame containing parameter samples and performance metrics}

\item{bins}{Integer number of bins for parameter range (default: 40)}

\item{mae_col}{Character name of column containing MAE values (default: "Holdout_MAE")}

\item{threshold_pct}{Numeric percentage above minimum for threshold calculation (default: 5)}

\item{min_samples}{Integer minimum number of samples required in a bin (default: 1)}
}
\value{
Object of class "parameter_sensitivity" containing:
\item{param_values}{Vector of parameter bin midpoints}
\item{min_mae}{Vector of minimum MAE values per bin}
\item{param_name}{Name of analyzed parameter}
\item{threshold}{Threshold value (default: Topolow min. +5\%)}
\item{min_value}{Minimum MAE value across all bins}
\item{sample_counts}{Number of samples per bin}
}
\description{
Analyzes the sensitivity of model performance (MAE) to changes in a parameter.
Uses binning to identify the minimum MAE across parameter ranges and calculates
thresholds for acceptable parameter values.
}
\details{
The function performs these steps:
\enumerate{
\item Cleans the input data using MAD-based outlier detection
\item Bins the parameter values into equal-width bins
\item Calculates the minimum MAE within each bin. Analogous to "poorman's likelihood" approach,
minimum MAE within each bin is an empirical estimate of the performance surface at this parameter
value when other parameters are at their optimal values.
\item Identifies a threshold of acceptable performance (default: Topolow min. +5\% MAE)
\item Returns an object for visualization and further analysis
}
}
