% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{save_plot}
\alias{save_plot}
\title{Save Plot to File}
\usage{
save_plot(plot, filename, layout_config = new_layout_config(), output_dir)
}
\arguments{
\item{plot}{ggplot or rgl scene object to save}

\item{filename}{Output filename (with or without extension)}

\item{layout_config}{Layout configuration object controlling output parameters}

\item{output_dir}{Character. Directory for output files. This argument is required.}
}
\value{
No return value, called for side effects (saves a plot to a file).
}
\description{
Saves a plot (ggplot or rgl scene) to file with specified configuration.
Supports multiple output formats and configurable dimensions.
}
\details{
Supported file formats:
\itemize{
\item PNG: Best for web and general use
\item PDF: Best for publication quality vector graphics
\item SVG: Best for web vector graphics
\item EPS: Best for publication quality vector graphics
}

The function will:
\enumerate{
\item Auto-detect plot type (ggplot or rgl)
\item Use appropriate saving method
\item Apply layout configuration settings
\item Add file extension if not provided
}
}
\examples{
# The sole purpose of save_plot is to write a file, so its example must demonstrate this. 
# For CRAN tests we wrap the example in \donttest{} to avoid writing files.
\donttest{
# Create a temporary directory for saving all plots
temp_dir <- tempdir()

# --- Example 1: Basic ggplot save ---
# Create sample data with 3 dimensions to support both 2D and 3D plots
data <- data.frame(
  V1 = rnorm(10), V2 = rnorm(10), V3 = rnorm(10), name=1:10,
  antigen = rep(c(0,1), 5), antiserum = rep(c(1,0), 5),
  year = 2000:2009
)
p <- plot_temporal_mapping(data, ndim=2)
save_plot(p, "temporal_plot.png", output_dir = temp_dir)

# --- Example 2: Save with custom layout ---
layout_config <- new_layout_config(
  width = 12,
  height = 8,
  dpi = 600,
  save_format = "pdf"
)
save_plot(p, "high_res_plot.pdf", layout_config, output_dir = temp_dir)

# --- Verify files and clean up ---
list.files(temp_dir)
unlink(temp_dir, recursive = TRUE)
}

}
