% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_true_divide}
\alias{torch_true_divide}
\title{True_divide}
\arguments{
\item{dividend}{(Tensor) the dividend}

\item{divisor}{(Tensor or Scalar) the divisor}
}
\description{
True_divide
}
\section{true_divide(dividend, divisor) -> Tensor }{


Performs "true division" that always computes the division
in floating point. Analogous to division in Python 3 and equivalent to
\code{\link{torch_div}} except when both inputs have bool or integer scalar types,
in which case they are cast to the default (floating) scalar type before the division.

\deqn{
    \mbox{out}_i = \frac{\mbox{dividend}_i}{\mbox{divisor}}
}
}

\examples{
if (torch_is_installed()) {

dividend = torch_tensor(c(5, 3), dtype=torch_int())
divisor = torch_tensor(c(3, 2), dtype=torch_int())
torch_true_divide(dividend, divisor)
torch_true_divide(dividend, 2)
}
}
