% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_smooth_l1_loss}
\alias{nn_smooth_l1_loss}
\title{Smooth L1 loss}
\usage{
nn_smooth_l1_loss(reduction = "mean")
}
\arguments{
\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Creates a criterion that uses a squared term if the absolute
element-wise error falls below 1 and an L1 term otherwise.
It is less sensitive to outliers than the \code{MSELoss} and in some cases
prevents exploding gradients (e.g. see \verb{Fast R-CNN} paper by Ross Girshick).
Also known as the Huber loss:
}
\details{
\deqn{
  \mbox{loss}(x, y) = \frac{1}{n} \sum_{i} z_{i}
}

where \eqn{z_{i}} is given by:

\deqn{
  z_{i} =
  \begin{array}{ll}
0.5 (x_i - y_i)^2, & \mbox{if } |x_i - y_i| < 1 \\
|x_i - y_i| - 0.5, & \mbox{otherwise }
\end{array}
}

\eqn{x} and \eqn{y} arbitrary shapes with a total of \eqn{n} elements each
the sum operation still operates over all the elements, and divides by \eqn{n}.
The division by \eqn{n} can be avoided if sets \code{reduction = 'sum'}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \eqn{*} means, any number of additional
dimensions
\item Target: \eqn{(N, *)}, same shape as the input
\item Output: scalar. If \code{reduction} is \code{'none'}, then
\eqn{(N, *)}, same shape as the input
}
}

