% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_softmin}
\alias{nn_softmin}
\title{Softmin}
\usage{
nn_softmin(dim)
}
\arguments{
\item{dim}{(int): A dimension along which Softmin will be computed (so every slice
along dim will sum to 1).}
}
\value{
a Tensor of the same dimension and shape as the input, with
values in the range \verb{[0, 1]}.
}
\description{
Applies the Softmin function to an n-dimensional input Tensor
rescaling them so that the elements of the n-dimensional output Tensor
lie in the range \verb{[0, 1]} and sum to 1.
Softmin is defined as:
}
\details{
\deqn{
  \mbox{Softmin}(x_{i}) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(*)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(*)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_softmin(dim = 1)
input <- torch_randn(2, 2)
output <- m(input)

}
}
