% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-loss.R
\name{nnf_poisson_nll_loss}
\alias{nnf_poisson_nll_loss}
\title{Poisson_nll_loss}
\usage{
nnf_poisson_nll_loss(
  input,
  target,
  log_input = TRUE,
  full = FALSE,
  eps = 1e-08,
  reduction = "mean"
)
}
\arguments{
\item{input}{tensor (N,*) where ** means, any number of additional dimensions}

\item{target}{tensor (N,*) , same shape as the input}

\item{log_input}{if \code{TRUE} the loss is computed as \eqn{\exp(\mbox{input}) - \mbox{target} * \mbox{input}},
if \code{FALSE} then loss is \eqn{\mbox{input} - \mbox{target} * \log(\mbox{input}+\mbox{eps})}.
Default: \code{TRUE}.}

\item{full}{whether to compute full loss, i. e. to add the Stirling approximation
term. Default: \code{FALSE}.}

\item{eps}{(float, optional) Small value to avoid evaluation of \eqn{\log(0)} when
\code{log_input}=\code{FALSE}. Default: 1e-8}

\item{reduction}{(string, optional) – Specifies the reduction to apply to the
output: 'none' | 'mean' | 'sum'. 'none': no reduction will be applied, 'mean':
the sum of the output will be divided by the number of elements in the output,
'sum': the output will be summed. Default: 'mean'}
}
\description{
Poisson negative log likelihood loss.
}
