% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_mul}
\alias{torch_mul}
\title{Mul}
\usage{
torch_mul(self, other)
}
\arguments{
\item{self}{(Tensor) the first multiplicand tensor}

\item{other}{(Tensor) the second multiplicand tensor}
}
\description{
Mul
}
\section{mul(input, other, out=NULL) }{


Multiplies each element of the input \code{input} with the scalar
\code{other} and returns a new resulting tensor.

\deqn{
    \mbox{out}_i = \mbox{other} \times \mbox{input}_i
}
If \code{input} is of type \code{FloatTensor} or \code{DoubleTensor}, \code{other}
should be a real number, otherwise it should be an integer



Each element of the tensor \code{input} is multiplied by the corresponding
element of the Tensor \code{other}. The resulting tensor is returned.

The shapes of \code{input} and \code{other} must be
broadcastable .

\deqn{
    \mbox{out}_i = \mbox{input}_i \times \mbox{other}_i
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(3))
a
torch_mul(a, 100)


a = torch_randn(c(4, 1))
a
b = torch_randn(c(1, 4))
b
torch_mul(a, b)
}
}
